#!/bin/bash
   # Script to reproduce results
 mkdir outlogs_buffer &> /dev/null
 declare -a tasks=( "3s5z" "1c3s5z" )
 ## TODO: "3s5z" "1c3s5z" "3c7z"
 ## "3s_vs_5z" "5m_vs_6m" "10m_vs_11m" "2s3z" "2s_vs_1sc" "3s5z" "1c3s5z" "3c7z" "3h_vs_4z"
 declare -a buffer_ids=( "23" "25" "27" )
 ## "23" "25" "27"
 declare -a algos=( "vdn" )
 ## "dmaq" "vdn" "qmix" "qtran"
 n=0
 gpunum=8
 for task in "${tasks[@]}"
 do
 for buffer_id in "${buffer_ids[@]}"
 do
 for algo in "${algos[@]}"
 do
 OMP_NUM_THREADS=16 KMP_AFFINITY="compact,granularity\=fine" CUDA_VISIBLE_DEVICES=${n} nohup python3 main.py \
 --config=${algo} --env-config=sc2 with env_args.map_name=${task} \
 env_args.seed=${buffer_id} \
 local_results_path='../../../tmp_DD/sc2_'${task}'/results/' \
 save_model=True \
 use_tensorboard=True \
 save_model_interval=200000 \
 t_max=2100000 \
 is_save_buffer=True \
 save_buffer_size=50000 \
 save_buffer_id=${buffer_id} \
 mac="mmdp_mac" \
 >& outlogs_buffer/${task}_${buffer_id}_${algo}_${buffer_id}.txt &
 echo "task: ${task}, buffer_ids: ${buffer_id}, algo: ${algo}, seed: ${buffer_id}, GPU: $n"
 n=$((($n+1) % ${gpunum}))
 sleep 5
 done
 done
 done