
from configs.train_options import TrainOptions
import pytorch_lightning as pl
import argparse

# from models_phoneix.point2text_model_vqvae_tr_latent_dm_stage2 import Point2textModelStage2
# from stage2_models.cond_mask_predict import Point2textModelStage2
from stage2_models.cond_discrete_dm import Point2textModelStage2
# from stage2_models.efficient_cond_discrete_dm import Point2textModelStage2
from pytorch_lightning.callbacks import ModelCheckpoint
from pytorch_lightning.callbacks.early_stopping import EarlyStopping
from data_phoneix.stage2_phoneix_data import PhoenixPoseData
from util.util import CheckpointEveryNSteps
from data.vocabulary import Dictionary
import os



def main():
    pl.seed_everything(1234)
    parser = argparse.ArgumentParser()
    parser = Point2textModelStage2.add_model_specific_args(parser)
    parser = pl.Trainer.add_argparse_args(parser)
    opt = TrainOptions(parser).parse()
    print(opt)

    # data = How2SignTextPoseData(opt)
    data = PhoenixPoseData(opt)
    data.train_dataloader()
    data.test_dataloader()

    text_dict = Dictionary()
    text_dict = text_dict.load(opt.vocab_file)
    model = Point2textModelStage2(opt, text_dict)
    
    def get_parameter_number(model):
        total_num = sum(p.numel() for p in model.parameters())
        trainable_num = sum(p.numel() for p in model.parameters() if p.requires_grad)
        print({'Total': total_num, 'Trainable': trainable_num})
    get_parameter_number(model)
    
    # if os.path.exists(opt.resume_ckpt):
    #     print("=== Load from {}!".format(opt.resume_ckpt))
    #     model = model.load_from_checkpoint(opt.resume_ckpt, strict=True)
    # else:
    #     print("=== {} is not existed!".format(opt.resume_ckpt))

    # model.back_translate_model1 = model.back_translate_model1.load_from_checkpoint(opt.backmodel, hparams_file=opt.backmodel_hparams_file)
    # model.back_translate_model2 = model.back_translate_model2.load_from_checkpoint(opt.backmodel2, hparams_file=opt.backmodel_hparams_file2, strict=False)

    callbacks = []
    model_save_ccallback = ModelCheckpoint(monitor="val/rec_wer", filename='{epoch}-{step}-{val/rec_wer:4f}', save_top_k=-1)
    # early_stop_callback = EarlyStopping(monitor="test_wer", min_delta=0.00, patience=100, verbose=False, mode="min")
    callbacks.append(model_save_ccallback)
    # callbacks.append(early_stop_callback)

    kwargs = dict()
    if opt.gpus > 1:
        kwargs = dict(distributed_backend='ddp', gpus=opt.gpus)
    trainer = pl.Trainer.from_argparse_args(opt, callbacks=callbacks, 
                                            max_steps=200000000, **kwargs)

    # trainer.validate(model, dataloaders=data.test_dataloader())
    trainer.fit(model, data)


if __name__ == "__main__":
    main()