clc;
clear all;

T = 40;
x0 = 10; 
signal_list = 4*sin((1:T)/2);
x_bound = 1e6;
num_run = 100;
%% choice of gamma: 0.3, 0.7
% gamma = 0.3;
gamma = 0.7;
%% choice of (a_t): Bern(p)*A + 1, with m_bound = 1, M_bound = 2 + A, where A = 0, 50, 500
A = 0;
p = 0.3;
a_list = (rand([1,T])<=p)*A+1;
m_bound = 2;
M_bound = 2+A;

%%
k_list = 1:20;
result_norm_PGM = zeros([num_run,length(k_list)]);
result_func_PGM = zeros([num_run,length(k_list)]);
result_norm_AGM = zeros([num_run,length(k_list)]);
result_func_AGM = zeros([num_run,length(k_list)]);

result_norm_PGM_zeroinit = zeros([num_run,length(k_list)]);
result_func_PGM_zeroinit = zeros([num_run,length(k_list)]);
result_norm_AGM_zeroinit = zeros([num_run,length(k_list)]);
result_func_AGM_zeroinit = zeros([num_run,length(k_list)]);

%% init for x: optimal to signal, all zero 
for i_sample = 1:num_run
    noise_list = get_noise_sequence(gamma, T);
    [x_opt, C_opt] = get_optimal(a_list,signal_list + noise_list,x0,x_bound);
    [x_init, C_init] = get_optimal(a_list,signal_list,x0,x_bound);
    x_init_allzero = zeros([1,T]);
    for i_k = 1:length(k_list)
        k = k_list(i_k);
        x_online_PGM = online_PGM(x_init, a_list,signal_list,noise_list,x0,k,m_bound, M_bound,x_bound,gamma);
        x_online_AGM = online_AGM(x_init, a_list,signal_list,noise_list,x0,k,m_bound, M_bound,x_bound,gamma);
        C_online_PGM = objective_func_eval(a_list,signal_list + noise_list,x0,x_online_PGM);
        C_online_AGM = objective_func_eval(a_list,signal_list + noise_list,x0,x_online_AGM);
        x_online_PGM_zeroinit = online_PGM(x_init_allzero, a_list,signal_list,noise_list,x0,k,m_bound, M_bound,x_bound,gamma);
        x_online_AGM_zeroinit = online_AGM(x_init_allzero, a_list,signal_list,noise_list,x0,k,m_bound, M_bound,x_bound,gamma);
        C_online_PGM_zeroinit = objective_func_eval(a_list,signal_list + noise_list,x0,x_online_PGM_zeroinit);
        C_online_AGM_zeroinit = objective_func_eval(a_list,signal_list + noise_list,x0,x_online_AGM_zeroinit);

        result_norm_PGM(i_sample,i_k) = norm(x_online_PGM - x_opt);
        result_func_PGM(i_sample,i_k) = C_online_PGM - C_opt;
        result_norm_AGM(i_sample,i_k) = norm(x_online_AGM - x_opt);
        result_func_AGM(i_sample,i_k) = C_online_AGM - C_opt;
        result_norm_PGM_zeroinit(i_sample,i_k) = norm(x_online_PGM_zeroinit - x_opt);
        result_func_PGM_zeroinit(i_sample,i_k) = C_online_PGM_zeroinit - C_opt;
        result_norm_AGM_zeroinit(i_sample,i_k) = norm(x_online_AGM_zeroinit - x_opt);
        result_func_AGM_zeroinit(i_sample,i_k) = C_online_AGM_zeroinit - C_opt;
    end
end

%% plots 

figure(1)
plot(k_list, log(mean(result_norm_PGM,1)),"r-^","DisplayName","o-PGM, x = x^*_{nf}","MarkerSize",12);
hold on;
plot(k_list, log(mean(result_norm_PGM_zeroinit,1)),"r-o","DisplayName","o-PGM, x = 0", "MarkerSize",12);
hold on;
plot(k_list, log(mean(result_norm_AGM,1)),"b-^","DisplayName","o-AGM, x = x^*_{nf}","MarkerSize",12);
hold on;
plot(k_list, log(mean(result_norm_AGM_zeroinit,1)),"b-o","DisplayName","o-AGM, x = 0","MarkerSize",12);

xlabel('$k$','Interpreter','latex')
ylabel('$\log(\|x - x^*\|)$','Interpreter','latex')
legend('Location',"east")
ax = gca; 
ax.FontSize = 16; 
name_norm = sprintf("gamma%dA%d_norm",floor(gamma*10),A);

saveas(gcf,name_norm,'epsc')


figure(2)
plot(k_list, log(mean(result_func_PGM,1)),"r-^","DisplayName","o-PGM, x = x^*_{nf}","MarkerSize",12);
hold on;
plot(k_list, log(mean(result_func_PGM_zeroinit,1)),"r-o","DisplayName","o-PGM, x = 0","MarkerSize",12);
hold on;
plot(k_list, log(mean(result_func_AGM,1)),"b-^","DisplayName","o-AGM, x = x^*_{nf}","MarkerSize",12);
hold on;
plot(k_list, log(mean(result_func_AGM_zeroinit,1)),"b-o","DisplayName","o-AGM, x = 0","MarkerSize",12);

xlabel('$k$','Interpreter','latex')
ylabel('$\log(C(x) - C(x^*)\|)$','Interpreter','latex')
legend()
ax = gca; 
ax.FontSize = 16; 
name_func = sprintf("gamma%dA%d_func",floor(gamma*10),A);
saveas(gcf,name_func,'epsc')

