function [x_opt, C_opt] = get_optimal(a_list,theta_list,x0,x_bound)
%%%%% set the gradient to 0, if not feasible, return [x_opt,-1]
n = length(a_list);
A = zeros([n,n]);
A(1,1) = a_list(1) + 1;
A(1,2) = -1/2;
for i = 2:(n-1)
    A(i,i) = a_list(i) + 1;
    A(i,i-1) = -1/2;
    A(i,i+1) = -1/2;
end
A(n-1,n) = -1/2;
A(n,n) = a_list(n)+1/2;

b = a_list.*theta_list;
b(1) = b(1) + x0/2;

x_opt = linsolve(A,b')';

C_opt = -1;
if (min(x_opt)>- x_bound) & (max(x_opt)< x_bound)
    temp = zeros([1 n]);
    temp(1) = x0;
    temp(2:n) = x_opt(1:(n-1));
    C_opt = sum(a_list.* (x_opt - theta_list).^2 + 1/2*(x_opt - temp).^2 )/2;
end

