function [x_opt] = online_AGM(x_init, a_list,signal_list,noise_list,x0,k,m_bound, M_bound,x_bound,gamma)
%%% theta = signal + noise, L = k, C is M-smooth where M <= M_bound and is
%%% m-strongly convex where m >= m_bound. 

T = length(x_init);

pred_noise_list = zeros([1,T]);
pred_theta_list = signal_list + pred_noise_list;


pred_theta_list = signal_list + noise_list;


computation_table_x = ones([k,T]) * (-x_bound);
computation_table_y = ones([k+1,T]) * (-x_bound);
computation_table_v = ones([k+1,T]) * (-x_bound);

kappa = m_bound/M_bound;
[alpha_list, tau_list] = get_alpha_list(kappa/4,k);

for i = 1: (k+1)
    computation_table_y(1,i) = x_init(i);
    computation_table_v(1,i) = - 2 * x_init(i);
end
for l = 1:k
    for s = 1: (1 + k - l)
        g = get_partial_derivative(a_list,pred_theta_list,computation_table_y(l,:),x0,s);
        computation_table_x(l,s) = computation_table_y(l,s) - g/2/M_bound;
        if abs(computation_table_x(l,s))>=x_bound
            computation_table_x(l,s) = sign(computation_table_x(l,s)) * x_bound;
            display("need projection")
        end
        
        computation_table_v(l+1,s) = computation_table_v(l,s) + alpha_list(l) * (g/M_bound - kappa/2 * computation_table_y(l,s));
        z = -computation_table_v(l+1,s)/(2 + kappa/2*sum(alpha_list(1:l)));
        if abs(z)>=x_bound
            z = sign(z) * x_bound;
            display("need projection")
        end
        computation_table_y(l+1,s) = tau_list(l) * z + (1-tau_list(l)) * computation_table_x(l,s);
            
    end
end

pred_noise_list(1) = noise_list(1);
pred_noise_list(2:T) = noise_list(1)* gamma.^(1:(T-1));
pred_theta_list = signal_list + pred_noise_list;

for t = 2:T
    if t + k <=T
        computation_table_y(1,t + k) = x_init(t + k);
        computation_table_v(1,t + k) = - 2 * x_init(t + k);
    end
    for l = 1:k
        if t + k - l<=T
            s = t + k - l;
            g = get_partial_derivative(a_list,pred_theta_list,computation_table_y(l,:),x0,s);
            computation_table_x(l,s) = computation_table_y(l,s) - g/2/M_bound;
            if abs(computation_table_x(l,s))>=x_bound
                computation_table_x(l,s) = sign(computation_table_x(l,s)) * x_bound;
                display("need projection")
            end
            computation_table_v(l+1,s) = computation_table_v(l,s) + alpha_list(l) * (g/M_bound - kappa/2 * computation_table_y(l,s));
            z = -computation_table_v(l+1,s)/(2 + kappa/2*sum(alpha_list(1:l)));
            if abs(z)>=x_bound
                z = sign(z) * x_bound;
                display("need projection")
            end
            computation_table_y(l+1,s) = tau_list(l) * z + (1-tau_list(l)) * computation_table_x(l,s);
        end
    end
    pred_noise_list(t) = noise_list(t);
    pred_noise_list((t+1):T) = noise_list(t)* gamma.^(1:(T-t));
    pred_theta_list = signal_list + pred_noise_list;
            
end
    




x_opt = computation_table_x(k,:);
