function [x_opt] = online_PGM(x_init, a_list,signal_list,noise_list,x0,k,m_bound, M_bound,x_bound,gamma)
%%% theta = signal + noise, L = k, C is M-smooth where M <= M_bound and is
%%% m-strongly convex where m >= m_bound. 

T = length(x_init);

pred_noise_list = zeros([1,T]);
pred_theta_list = signal_list + pred_noise_list;

computation_table = ones([k+1,T]) * (-x_bound);

for i = 1: (k+1)
    computation_table(1,i) = x_init(i);
end
for l = 1:k
    for s = 1: (1 + k - l)
        g = get_partial_derivative(a_list,pred_theta_list,computation_table(l,:),x0,s);
        computation_table(l+1,s) = computation_table(l,s) - g/2/M_bound;
        if abs(computation_table(l+1,s))>=x_bound
            computation_table(l+1,s) = sign(computation_table(l+1,s)) * x_bound;
            display("need projection")
        end
            
    end
end

pred_noise_list(1) = noise_list(1);
pred_noise_list(2:T) = noise_list(1)* gamma.^(1:(T-1));
pred_theta_list = signal_list + pred_noise_list;

for t = 2:T
    if t + k <=T
        computation_table(1,t + k) = x_init(t + k);
    end
    for l = 1:k
        if t + k - l<=T
            s = t + k - l;
            g = get_partial_derivative(a_list,pred_theta_list,computation_table(l,:),x0,s);
            computation_table(l+1,s) = computation_table(l,s) - g/2/M_bound;
            if abs(computation_table(l+1,s))>=x_bound
                computation_table(l+1,s) = sign(computation_table(l+1,s)) * x_bound;
                display("need projection")
            end
        end
    end
    pred_noise_list(t) = noise_list(t);
    pred_noise_list((t+1):T) = noise_list(t)* gamma.^(1:(T-t));
    pred_theta_list = signal_list + pred_noise_list;

end


%%% kappa for the problem is bdd by m_bound/M_bound, and so m/M = kappa/4
%%% is bdd by m_bound/M_bound/4

w = (1-m_bound/M_bound/4).^(k - (1:k));
w = w./sum(w);

x_opt = zeros([1,T]);
for l = 1:k
    x_opt = x_opt + w(l) * computation_table(l+1,:);
end

