import json
import spacy
import requests
from tqdm import tqdm

import pandas as pd
from sklearn.metrics import accuracy_score

class DelphiScanner:
    def __init__(self):
        self.url = "https://mosaic-api-frontdoor.apps.allenai.org/predict?action1="

    def query(self, q):
        self.url = 'https://mosaic-api-frontdoor.apps.allenai.org/predict?action1=' + q
        return requests.get(self.url)

def produce_responses(data_path='../../data/moral_dilemma.json', annotation_csv_path='../../data/moral dilemma - Annotations.csv'):
    data = json.load(open(data_path))
    scan = DelphiScanner()

    nlp = spacy.load('en_core_web_sm')
    df = pd.read_csv(annotation_csv_path)
    statements = df['last sentence rewrite'].tolist()

    full_label_list = []
    delphi_answers = []
    for i, ex in tqdm(enumerate(data['examples']), total=len(data['examples'])):
        text = ex['input']
        statement = statements[i]

        sentences = [str(s) for s in nlp(text).sents]
        q = sentences[-1]

        text = ' '.join(sentences[:-1])
        text += " You have to make a choice or both groups will die." + ' ' + statement

        corr_label = 'yes' if ex['target_scores']['Yes'] == 1 else 'no'
        full_label_list.append(corr_label)

        answer_query = scan.query(text).json()

        delphi_answers.append(answer_query)

    return delphi_answers, full_label_list

def produce_and_evaluate_answers(delphi_answers, data_path='../../data/moral_dilemma.json'):
    data = json.load(open(data_path))

    preds, labels = [], []
    mapping = {'yes': 1, 'no': 0}
    ans_chocies = ['no', 'yes']
    for a in delphi_answers:
        p = a['answer']['class']
        if p >= 0:
            preds.append(mapping['yes'])
        else:
            preds.append(mapping['no'])

    for i, ex in enumerate(data['examples']):
        corr_ans = "yes" if ex['target_scores']['Yes'] == 1 else "no"
        labels.append(mapping[corr_ans])

    print(accuracy_score(labels, preds))
