from ml_collections import config_dict

def get_config():
    cfg = config_dict.ConfigDict()

    cfg.alg_name = 'lsb'
    cfg.dim = 64
    cfg.n_potential = 100
    cfg.eps = 0.1
    cfg.S_init = 1.0
    cfg.diagonal = True

    cfg.plan_type = 'ind'

    cfg.lr = 1e-3
    cfg.batch_size = 512
    cfg.eval_size = 100000

    cfg.eval_itvl = 5000
    cfg.max_step = 30000
    cfg.burn_in = 0.0

    cfg.md = config_dict.ConfigDict()
    cfg.md.eta_start = 1.0
    cfg.md.eta_end = 0.01
    cfg.md.itvl = 50
    cfg.md.sample_size = 128

    cfg.seed = 42
    cfg.data_preload = False

    return cfg
