from ml_collections import config_dict

def get_config():
    cfg = config_dict.ConfigDict()

    cfg.alg_name = 'lsb'
    cfg.dim = 50
    cfg.n_potential = 10
    cfg.eps = 0.1
    cfg.S_init = 1.
    cfg.diagonal = True

    cfg.day_start = 3
    cfg.day_eval = 4
    cfg.day_end = 7

    cfg.lr = 1e-2
    cfg.batch_size = 512
    cfg.eval_size = 10000
    cfg.eval_itvl = 1000
    cfg.max_step = 10000

    cfg.md = config_dict.ConfigDict()
    cfg.md.eta_start = 1.0
    cfg.md.eta_end = 0.01
    cfg.md.itvl = 50
    cfg.md.sample_size = 256

    cfg.seed = 42

    return cfg
