using Serialization, CairoMakie, ColorSchemes # CairoMakie 

include("Data.jl"); using .Data; include("Pds.jl"); using .Pds
const data = scurve
const savepath = mkpath(joinpath(@__DIR__, "save", string(data)))
const figpath = mkpath(joinpath(@__DIR__, "fig", string(data)))

const labels = [L"\eta=2.0", L"\eta=1.0", L"\eta=0.5", L"\eta=0.1", L"\eta=0.01"]
const suffixes = ["2_2", "1_1", "0.5_0.5", "0.1_0.1", "1e-2_1e-2"]
const suffix = "1_5e-2"

const md_trial = 1
const ml_trial = 1
const md_trial_str = lpad(md_trial, 2, '0')
const ml_trial_str = lpad(ml_trial, 2, '0')
const md_idx = 301 # 301
const ml_idx = 301 # 301


const datalim = 3.5
const plotlim = 3.5
const ticklim = 3
const tickitvl = 3
const num = 601 # 401
const α = 0.2
# :coolwarm
const cmap = cgrad(:nuuk; scale = :log) # :ice # :inferno # :ice # :grays # :darkrainbow # :heat # :blues # :amp # :winter # :tokyo # :imola # :broc # :berlin # :batlowK # :bamako # # parula # :cividis # parula # :coolwarm # :jet # :plasma # :inferno # :cool # :Blues # :viridis

const x = LinRange(-datalim, datalim, num)
const y = LinRange(-datalim, datalim, num)
const xy = copy([repeat(x, outer=length(y)) repeat(y, inner=length(x))]')
const size_small = (800, 800)

# f = Figure(size = (1600, 1200), fontsize = 22)
# f = Figure(size = (1200, 900), fontsize = 22)
f = Figure(size = (600, 600), fontsize = 22)

const
ax = 
   Axis(f[1, 1]; 
      title = "Ground-truth marginal", titlesize=32, #      
      aspect = AxisAspect(1), 
      backgroundcolor=:transparent,
      xticks=-ticklim:tickitvl:ticklim,
      yticks=-ticklim:tickitvl:ticklim,
      xlabelvisible=false,
      ylabelvisible=false,
      ygridcolor=:white, xgridcolor=:white,
      limits=((-plotlim, plotlim), (-plotlim, plotlim)),
      xgridwidth=4, ygridwidth=4,
      spinewidth=3)

sample = data(2048)
dist = sqrt.(dropdims(sum(sample.^2; dims=1); dims=1))

scatter!(ax, sample[1,:], sample[2,:]; color=.-dist, colormap=cgrad(:viridis; scale = :exp), markersize=20)


let filename = joinpath(figpath, "scatter.png")
   save(filename, f)
   run(`convert $filename -trim $filename`)
end


