from ml_collections import config_dict

def get_config():
    cfg = config_dict.ConfigDict()

    cfg.alg_name = 'lsb'
    cfg.dim = 512
    cfg.n_potential = 10
    cfg.eps = 0.1
    cfg.S_init = 0.1
    cfg.diagonal = True

    cfg.input_group = 'adult'
    cfg.target_group = 'child'

    cfg.train_size = 60000
    cfg.test_size = 10000

    cfg.lr = 1e-3
    cfg.batch_size = 128
    cfg.max_step = 20000

    cfg.md = config_dict.ConfigDict()
    cfg.md.eta_start = 1.0
    cfg.md.eta_end = 0.01
    cfg.md.itvl = 50
    cfg.md.sample_size = 256

    cfg.seed = 42
    cfg.data_preload = False
    cfg.n_pic = 2

    return cfg
