from ml_collections import config_dict

def get_config():
    cfg = config_dict.ConfigDict()

    cfg.mu = 'moons'
    cfg.nu = 'scurve'

    cfg.alg_name = 'lsb'
    cfg.dim = 2
    cfg.n_potential = 100 
    cfg.eps = 0.1
    cfg.S_init = 0.1
    cfg.diagonal = True

    cfg.lr = 3e-3
    cfg.batch_size = 128
    cfg.max_step = 20000
    cfg.burn_in = 0.0

    cfg.md = config_dict.ConfigDict()
    cfg.md.eta_start = 1.0
    cfg.md.eta_end = 0.03
    cfg.md.itvl = 50
    cfg.md.sample_size = 100
    cfg.md.accumulation = 1

    cfg.seed = 42
    cfg.burn_in = 0.0

    return cfg
