from ml_collections import config_dict

def get_config():
    cfg = config_dict.ConfigDict()

    cfg.alg_name = 'lsb'
    cfg.dim = 2
    cfg.n_potential = 500
    cfg.eps = 0.1
    cfg.S_init = 1.
    cfg.diagonal = False

    cfg.lr = 1e-3 # 3e-4
    cfg.batch_size = 128
    cfg.eval_size = 1000
    cfg.eval_itvl = 1000
    cfg.max_step = 20000

    cfg.md = config_dict.ConfigDict()
    cfg.md.eta_start = 1.0
    cfg.md.eta_end = 0.1
    cfg.md.itvl = 200
    cfg.md.sample_size = 128

    cfg.seed = 42

    return cfg
