#!/bin/bash
# Script to update documentation modules and build HTML

# =================================================
#  FRAME Documentation Generator
#  This script generates Sphinx documentation
#  including all modules: productions, environments,
#  interestingness metrics, policies,
#  and demonstrations
# =================================================

# Set script to exit on any error
set -e

# Display header
echo "=========================================="
echo "  Generating FRAME Documentation"
echo "=========================================="

# Get the directory of this script
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
cd "$SCRIPT_DIR"

echo "Updating production rules documentation..."
python update_production_docs.py

echo "Updating environments documentation..."
python update_environments_docs.py

echo "Updating interestingness metrics documentation..."
python update_interestingness_docs.py

echo "Updating policies documentation..."
python update_policies_docs.py

echo "Updating demonstrations documentation..."
python update_demonstrations_docs.py

echo "Building HTML documentation..."
make html

echo "=========================================="
echo "  Documentation built successfully!"
echo "  HTML output is in build/html/"
echo "  To view documentation, run:"
echo "  python -m http.server -d build/html 8000"
echo "  And open http://localhost:8000 in your browser"
echo "==========================================" 