import os
import glob

# Generate concept production rule docs
concept_modules = glob.glob("../frame/productions/concepts/*.py")
concept_modules = [
    os.path.basename(f)
    for f in concept_modules
    if not os.path.basename(f).startswith("__")
]

for module in concept_modules:
    module_name = os.path.splitext(module)[0]
    class_name = "".join(word.capitalize() for word in module_name.split("_")) + "Rule"
    rst_content = f"""{class_name}
{"=" * len(class_name)}

.. automodule:: frame.productions.concepts.{module_name}
   :members:
   :undoc-members:
   :show-inheritance:
"""
    os.makedirs("source/frame/productions/concepts", exist_ok=True)
    with open(f"source/frame/productions/concepts/{module_name}.rst", "w") as f:
        f.write(rst_content)

# Generate conjecture production rule docs
conjecture_modules = glob.glob("../frame/productions/conjectures/*.py")
conjecture_modules = [
    os.path.basename(f)
    for f in conjecture_modules
    if not os.path.basename(f).startswith("__")
]

for module in conjecture_modules:
    module_name = os.path.splitext(module)[0]
    class_name = "".join(word.capitalize() for word in module_name.split("_")) + "Rule"
    rst_content = f"""{class_name}
{"=" * len(class_name)}

.. automodule:: frame.productions.conjectures.{module_name}
   :members:
   :undoc-members:
   :show-inheritance:
"""
    os.makedirs("source/frame/productions/conjectures", exist_ok=True)
    with open(f"source/frame/productions/conjectures/{module_name}.rst", "w") as f:
        f.write(rst_content)

print("Generated documentation files for all production rules.")
