from enum import Enum
from dataclasses import dataclass
from typing import Dict, Set, Optional, Callable, List

class EntityType(Enum):
    CONCEPT = "concept"
    CONJECTURE = "conjecture"
    THEOREM = "theorem"

@dataclass
class GroundTruthEntity:
    """Represents a ground truth mathematical entity with its canonical name and implementation."""
    canonical_name: str
    entity_type: EntityType
    description: str
    computational_implementation: Optional[Callable] = None
    discovered_names: Set[str] = None  # Names that can be discovered for this entity
    new_examples: Optional[Set] = None
    new_nonexamples: Optional[Set] = None
    z3_translation: Optional[Callable] = None

    def __post_init__(self):
        if self.discovered_names is None:
            self.discovered_names = set() 


def is_prime(n):
    result = len([d for d in range(1, n+1) if n % d == 0]) == 2
    return result