"""
This package contains production rules for generating new mathematical concepts.

Each production rule takes existing concepts and produces new ones through
various transformations like:
- Map/iteration (e.g., successor -> addition)
- Composition (e.g., add3 ∘ add2 -> add5)
- Negation (e.g., is_even -> is_odd)
- Existential quantification (e.g., divides_and_even -> has_even_divisor)
- Argument matching (e.g., multiply(a,b) -> square(n))
- Specialization (e.g., proper_divisors_count(n,k) -> has_one_proper_divisor(n))
- Size (e.g., cardinality of a set or predicate-defined set)
"""

from frame.productions.concepts.compose import ComposeRule
from frame.productions.concepts.exists import ExistsRule
from frame.productions.concepts.map_iterate import MapIterateRule
from frame.productions.concepts.match import MatchRule
from frame.productions.concepts.negate import NegateRule
from frame.productions.concepts.specialize import SpecializeRule
from frame.productions.concepts.size import SizeRule
from frame.productions.concepts.constant import ConstantRule
from frame.productions.concepts.forall import ForallRule

__all__ = [
    "ComposeRule",
    "ExistsRule",
    "MapIterateRule",
    "MatchRule",
    "NegateRule",
    "SpecializeRule",
    "SizeRule",
    "ConstantRule",
    "ForallRule",
]
