"""
This package contains production rules for generating new mathematical conjectures.

Each production rule takes existing concepts/conjectures and produces new conjectures
through various transformations like:
    - Equivalence (e.g., even perfect numbers ↔ numbers of Mersenne form)
    - Implication (e.g., every even square number → divisible by 4)
    - Nonexistence (e.g., there are no odd perfect numbers)
    - Exclusivity (e.g., there is only one even prime number (2))
    - Generalization (e.g., lifting a property from examples)
    - Composition (e.g., combining multiple conjectures)
    - Strengthening/weakening (e.g., adding/removing conditions)
    - Analogy (e.g., transferring patterns between domains)
"""

from .equivalence import EquivalenceRule, test_equivalence
from .implication import ImplicationRule, test_implication
from .nonexistence import NonexistenceRule, test_nonexistence
from .exclusivity import ExclusivityRule, test_exclusivity

__all__ = [
    'EquivalenceRule',
    'ImplicationRule',
    'NonexistenceRule',
    'ExclusivityRule',
    'test_equivalence',
    'test_implication',
    'test_nonexistence',
    'test_exclusivity'
] 