namespace Basics

class Group (G : Type) where
  mul : G → G → G
  one : G
  inv : G → G
  mul_assoc : ∀ (a b c : G), mul (mul a b) c = mul a (mul b c)
  one_mul : ∀ (a : G), mul one a = a
  mul_one : ∀ (a : G), mul a one = a
  mul_left_inv : ∀ (a : G), mul (inv a) a = one

instance [g : Group G] : Mul G where
  mul := g.mul

notation:70 a " * " b:70 => Group.mul a b

end Basics
