namespace Basics

inductive Nat where
  | zero : Nat
  | succ : Nat → Nat
  deriving Repr

def Nat.add : Nat → Nat → Nat
  | n, zero => n
  | n, succ m => succ (add n m)

def Nat.mul : Nat → Nat → Nat
  | _, zero => zero
  | n, succ m => add n (mul n m)

theorem Nat.mul_2_2 : Nat.mul (Nat.succ Nat.zero) (Nat.succ Nat.zero) = Nat.succ Nat.zero := by
  rfl

end Basics
