#!/bin/bash
# Script to run an experiment with a standard policy (not interestingness-guided)

echo "Running experiment with interestingness-guided policy with the weighted-by-performance interestingness function of HR measures..."

# Go to the project root directory
cd "$(dirname "$0")/.."

# TODO(_; 4/23): Add the path once the weights have been decided by the other experiments.
# Run the experiment with the standard policy config
python -m frame.theory_builder \
  --config-name succ_zero_standard_experiment \
  experiment.num_episodes=64 \
  experiment.max_steps=1000 \
  experiment.episode_timeout_seconds=120 \
  experiment.num_workers=32 \
  z3_usage.use_z3_prover=true \
  z3_usage.use_z3_example_search=true \
  ++policy.params.interestingness_function_path=""


echo "Experiment completed!" 