#!/bin/bash
# Script to run an experiment using an existing interestingness function
# instead of generating a new one.

echo "Running experiment with existing interestingness function..."

# Go to the project root directory
cd "$(dirname "$0")/.."

# Enable interestingness debugging
export INTERESTINGNESS_DEBUG=1


# TODO(_; 4/23): THIS IS FOR TESTING SPECIFIC PATHS!
# Run the experiment with the existing interestingness config
nohup python -m frame.theory_builder \
  --config-name succ_zero_existing_interestingness_experiment \
  experiment.num_episodes=128 \
  experiment.max_steps=1000 \
  experiment.episode_timeout_seconds=30 \
  experiment.num_workers=128 \
  z3_usage.use_z3_prover=true \
  z3_usage.use_z3_example_search=true \
  ++policy.params.interestingness_function_path="frame/interestingness/learning/tests/gpt4o_test_1.py"

echo "Experiment completed!" 