#!/bin/bash
# Script to run FunSearch WITHOUT the abstraction mechanism, using Hydra defaults.

echo "Running FunSearch experiment without abstraction (using defaults from mid.yaml)..."

# --- Configurable Parameters ---
# Most parameters are now expected to be set in configs/funsearch/mid.yaml
# You can still override specific ones via the command line below if needed.
# OUTPUT_DIR is now managed by Hydra.
# --- End Configurable Parameters ---

# Go to the project root directory
cd "$(dirname "$0")/.."

# Hydra will create the output directory.

echo "Output directory will be managed by Hydra."
echo "Running with defaults from funsearch-mid.yaml and:"
echo "  Abstraction: DISABLED"

# Run the FunSearch main script using Hydra overrides
# Only disabling abstraction explicitly.
python -m frame.funsearch.main \
  --config-name funsearch-mid \
  abstraction.enabled=false

echo "FunSearch experiment without abstraction completed!"
# Output directory location depends on Hydra configuration (e.g., ./outputs/YYYY-MM-DD/HH-MM-SS)
echo "Results saved in Hydra output directory."
