"""
Test suite for production rules and their example transformations.

Each production rule has its own test class that tests both:
1. Core functionality (rule application, translations)
2. Example transformations

The tests for each production rule are in their respective files.
This file serves as a central point to run all tests.
"""


from frame.productions.conjectures.equivalence import test_equivalence
from frame.productions.conjectures.implication import test_implication
from frame.productions.conjectures.nonexistence import test_nonexistence
from frame.productions.conjectures.exclusivity import test_exclusivity


def main():
    """Run all production rule tests"""
    print("\n=== Running All Production Rule Tests ===")

    print("\n=== Testing Conjecture Production Rules ===")

    # Test Equivalence
    print("\nRunning Equivalence tests...")
    test_equivalence()

    # Test Implication
    print("\nRunning Implication tests...")
    test_implication()

    # Test Nonexistence
    print("\nRunning Nonexistence tests...")
    test_nonexistence()

    # Test Exclusivity
    print("\nRunning Exclusivity tests...")
    test_exclusivity()

    print("\n=== All Tests Complete ===")


if __name__ == "__main__":
    main()
