from typing import Dict, Set, Optional, Callable, Any, Tuple, List
from dataclasses import dataclass
from enum import Enum
import re

from frame.environments.ground_truth_types import GroundTruthEntity, EntityType

#TODO(_; 5/6): add implication patterns for equivalences
NT_CONJECTURES = {
    "sum_of_evens_is_even": GroundTruthEntity(
        canonical_name='sum_of_evens_is_even',
        entity_type=EntityType.CONJECTURE,
        description='Equivalence conjecture that sum of evens is even',
        discovered_names={"equiv_(is_sum_of_evens_is_even)",
                          "equiv_(is_even_is_sum_of_evens)",
                          "implies_(is_sum_of_evens_is_even)",
                          "implies_(is_even_is_sum_of_evens)",
                        "forall_(eq_sum_of_doubles_with_is_even_indices_to_map_{2: 0}_indices_to_quantify_[0, 1, 2])"}

    ),
    "sum_of_odds_is_even": GroundTruthEntity(
        canonical_name='sum_of_odds_is_even',
        entity_type=EntityType.CONJECTURE,
        description='Equivalence conjecture that sum of odds is even',
        discovered_names={"equiv_(is_sum_of_odds_is_even)",
                          "equiv_(is_even_is_sum_of_odds)",
                          "implies_(is_sum_of_odds_is_even)",
                          "implies_(is_even_is_sum_of_odds)",
                          "forall_(eq_sum_of_doubles_incr_with_is_even_indices_to_map_{2: 0}_indices_to_quantify_[0, 1, 2])"}
    ),
    "sum_of_even_odd_is_odd": GroundTruthEntity(
        canonical_name='sum_of_even_odd_is_odd',
        entity_type=EntityType.CONJECTURE,
        description='Equivalence conjecture that sum of even and odd is odd',
        discovered_names={"equiv_(is_sum_of_even_odd_is_odd)",
                          "equiv_(is_odd_is_sum_of_even_odd)",
                          "implies_(is_sum_of_even_odd_is_odd)",
                          "implies_(is_odd_is_sum_of_even_odd)"}
    ),
    "product_even_factor_is_even": GroundTruthEntity(
        canonical_name="product_even_factor_is_even",
        entity_type=EntityType.CONJECTURE,
        description="product_even_factor_is_even",
        discovered_names={"forall_(eq_product_doubled_factor_with_is_even_indices_to_map_{2: 0}_indices_to_quantify_[0, 1, 2])"}
    ),
    "product_odds_is_odd": GroundTruthEntity(
        canonical_name="product_odds_is_odd",
        entity_type=EntityType.CONJECTURE,
        description="product_odds_is_odd",
        discovered_names={"forall_(eq_product_doubled_incr_factors_with_is_odd_indices_to_map_{2: 0}_indices_to_quantify_[0, 1, 2])"}
    ),
    "divides_reflexivity": GroundTruthEntity(
        canonical_name='divides_reflexivity',
        entity_type=EntityType.CONJECTURE,
        description='Divides is reflexive for all n!=0',
        discovered_names={"forall_(gt_zero_with_divides_self_indices_to_map_{0: 0}_indices_to_quantify_[0])",
                          "implies_(gt_zero_divides_self)"}
    ),
    "positives_divisors_of_zero": GroundTruthEntity(
        canonical_name="positives_divisors_of_zero",
        entity_type=EntityType.CONJECTURE,
        description='all positive nums are divisors of zero',
        discovered_names={"forall_(gt_zero_with_is_divisor_of_zero_indices_to_map_{0: 0}_indices_to_quantify_[0])"}
    ),
    "divisor_leq_multiple": GroundTruthEntity(
        canonical_name="divisor_leq_multiple",
        entity_type=EntityType.CONJECTURE,
        description='If x|y and y != 0, then x <= y',
        discovered_names={"implies_(divides_and_multiple_gt_zero_leq)",
                          "implies_(multiple_gt_zero_and_divides_geq)"}
    ),
    "common_divisor_two_numbers": GroundTruthEntity(
        canonical_name="common_divisor_two_numbers",
        entity_type=EntityType.CONJECTURE,
        description='if x | y and x | z then x | ay + bz for all ints a and b',
        discovered_names={"forall_(divides_both_numbers_with_divides_sum_two_products_indices_to_map_{0: 4, 1: 1, 2: 3}_indices_to_quantify_[0, 1, 2, 3, 4])",
                          "forall_(divides_both_numbers_with_divides_sum_two_products_indices_to_map_{0: 4, 1: 0, 2: 3}_indices_to_quantify_[0, 1, 2, 3, 4])",
                          "forall_(divides_both_numbers_with_divides_sum_two_products_indices_to_map_{0: 4, 1: 1, 2: 2}_indices_to_quantify_[0, 1, 2, 3, 4])",
                          "forall_(divides_both_numbers_with_divides_sum_two_products_indices_to_map_{0: 4, 1: 0, 2: 2}_indices_to_quantify_[0, 1, 2, 3, 4])",}
    ),
    "even_squares_divis_by_four": GroundTruthEntity(
        canonical_name="even_squares_divis_by_four",
        entity_type=EntityType.CONJECTURE,
        description='even_squares_divis_by_four',
        discovered_names={"equiv_(divis_by_four_is_even_square)", "equiv_(is_even_square_divis_by_four)",
                          "implies_(divis_by_four_is_even_square)", "implies_(is_even_square_divis_by_four)"}
    ),
    "no_prime_square": GroundTruthEntity(
        canonical_name="no_prime_square",
        entity_type=EntityType.CONJECTURE,
        description='There is no prime square',
        discovered_names={"no_(is_prime_square)",
                          "forall_(is_not_prime_square)"}
    ),
    "two_is_even_prime": GroundTruthEntity(
        canonical_name="two_is_even_prime",
        entity_type=EntityType.CONJECTURE,
        description='two is (only) even prime',
        discovered_names={"equiv_(eq_two_is_even_prime)", "equiv_(is_even_prime_eq_two)",
                          "implies_(eq_two_is_even_prime)", "implies_(is_even_prime_eq_two)",
                        "implies_(is_prime_ne_two_is_odd)",
                        "forall_(is_prime_ne_two_with_is_odd_indices_to_map_{0: 0}_indices_to_quantify_[0])"}
    ),    
    "divides_each_other_equals": GroundTruthEntity(
        canonical_name="divides_each_other_equals",
        entity_type=EntityType.CONJECTURE,
        description='If two numbers divide each other then they are equal',
        discovered_names={"implies_(divides_each_other_eq)"}
    ),
    "nonzero_square_odd_number_divisors": GroundTruthEntity(
        canonical_name="nonzero_square_odd_number_divisors",
        entity_type=EntityType.CONJECTURE,
        description="nonzero_square_odd_number_divisors",
        discovered_names={"equiv_(is_nonzero_square_odd_number_divisors)", "equiv_(odd_number_divisors_is_nonzero_square)",
                          "implies_(is_nonzero_square_odd_number_divisors)", "implies_(odd_number_divisors_is_nonzero_square)",
                          "forall_(gt_zero_with_is_square_and_odd_number_divisors_indices_to_map_{0: 0}_indices_to_quantify_[0])",
                          "forall_(gt_zero_with_not_square_and_even_number_divisors_indices_to_map_{0: 0}_indices_to_quantify_[0])"}
    ),
    "fermats_last_thm": GroundTruthEntity(
        canonical_name="fermats_last_thm",
        entity_type=EntityType.CONJECTURE,
        description='No three pos ints a, b, c satisfy a^n + b^n = c^n for n > 2',
        discovered_names={"no_(fermats_last_thm_false)",
                          "forall_(gt_two_with_fermats_last_thm_true_1_indices_to_map_{0: 1}_indices_to_quantify_[0, 1, 2, 3])",
                          "forall_(gt_two_with_fermats_last_thm_true_2_indices_to_map_{0: 1}_indices_to_quantify_[0, 1, 2, 3])"
                          }
    ),
    "infinitely_many_nats": GroundTruthEntity(
        canonical_name="infinitely_many_nats",
        entity_type=EntityType.CONJECTURE,
        description='There exist infinitely many natural numbers',
        discovered_names={"forall_(exists_gt_indices_to_quantify_[0])"}
    ),  
    "infinitely_many_primes": GroundTruthEntity(
        canonical_name="infinitely_many_primes",
        entity_type=EntityType.CONJECTURE,
        description='There exist infinitely many primes',
        discovered_names={"forall_(exists_is_prime_gt_indices_to_quantify_[0])"}
    ),  
    "twin_primes_conjecture": GroundTruthEntity(
        canonical_name="twin_primes_conjecture",
        entity_type=EntityType.CONJECTURE,
        description='There exist infinitely many twin primes',
        discovered_names={"forall_(exists_is_twin_prime_gt_indices_to_quantify_[0])"}
    ),  
    "bertrand_postulate": GroundTruthEntity(
        canonical_name="bertrand_postulate",
        entity_type=EntityType.CONJECTURE,
        description='there exists prime p for all n > 1 s.t. n < p < 2n',
        discovered_names={"forall_(gt_one_with_bertrand_postulate_q_indices_to_map_{0: 0}_indices_to_quantify_[0])",
                          "forall_(gt_two_with_bertrand_postulate_q_indices_to_map_{0: 0}_indices_to_quantify_[0])",
                          "forall_(gt_three_with_bertrand_postulate_q_indices_to_map_{0: 0}_indices_to_quantify_[0])"}
    ),
    "goldbach_strong": GroundTruthEntity(
        canonical_name="goldbach_strong",
        entity_type=EntityType.CONJECTURE,
        description='every even natural > 2 is sum of two primes',
        discovered_names={"forall_(gt_two_even_with_goldbach_strong_q_indices_to_map_{0: 0}_indices_to_quantify_[0])",}
    ),
    "goldbach_weak": GroundTruthEntity(
        canonical_name="goldbach_weak",
        entity_type=EntityType.CONJECTURE,
        description='for every natural > 5 there exists three primes that sum to it',
        computational_implementation=None, 
        discovered_names={"forall_(gt_five_with_goldbach_weak_q_indices_to_map_{0: 0}_indices_to_quantify_[0])",}
    ),
    "legendre_conjecture": GroundTruthEntity(
        canonical_name="legendre_conjecture",
        entity_type=EntityType.CONJECTURE,
        description='there is a prime number p between n^2 and (n+1)^2 for all n',
        discovered_names={"forall_(gt_zero_with_legendre_conjecture_q_indices_to_map_{0: 0}_indices_to_quantify_[0])",
                          "forall_(gt_one_with_legendre_conjecture_q_indices_to_map_{0: 0}_indices_to_quantify_[0])",
                          "forall_(gt_two_with_legendre_conjecture_q_indices_to_map_{0: 0}_indices_to_quantify_[0])"}
    ),
    "fermats_little_thm": GroundTruthEntity(
        canonical_name="fermats_little_thm",
        entity_type=EntityType.CONJECTURE,
        description='a^p = a mod p for any int a if p is prime',
        discovered_names={"forall_(is_prime_with_is_mod_power_matched_base_res_pwr_mod_indices_to_map_{0: 1}_indices_to_quantify_[0, 1])"}
    ),
    "euler_sum_of_powers": GroundTruthEntity(
        canonical_name="euler_sum_of_powers",
        entity_type=EntityType.CONJECTURE,
        description='no a, b, c, d s.t. a^4 + b^4 + c^4 == d^4 and a > 0 and b > 0 and c > 0 and d > 0',
        discovered_names={"no_(sum_of_fourth_powers_equals_fourth_power)"}
    ),
    "infinitely_many_pythagorean_triples": GroundTruthEntity(
        canonical_name="infinitely_many_pythagorean_triples",
        entity_type=EntityType.CONJECTURE,
        description="infinitely_many_pythagorean_triples",
        discovered_names={"forall_(exists_pythagorean_triple_gt_indices_to_quantify_[0])"}
    ), 
}

NT_PRED_ALWAYS_TRUE={
    "is_not_prime_square": GroundTruthEntity(
        canonical_name="is_not_prime_square",
        entity_type=EntityType.CONCEPT,
        description='Is not prime and square',
        computational_implementation=lambda n: True,
        discovered_names={"not_(is_prime_square)"}
    ),
    "exists_gt": GroundTruthEntity(
        canonical_name="exists_gt",
        entity_type=EntityType.CONCEPT,
        description='there exists a s.t. a > b',
        computational_implementation=lambda a: True,
        discovered_names={"exists_(gt_indices_[0])",
                          "exists_(lt_indices_[1])"}
    ),
    "exists_is_prime_gt": GroundTruthEntity(
        canonical_name="exists_is_prime_gt",
        entity_type=EntityType.CONCEPT,
        description='there exists a s.t. a > b and a is prime',
        computational_implementation=lambda m: True,
        discovered_names={"exists_(is_prime_gt_indices_[0])",
                          "exists_(lt_is_prime_indices_[1])"}
    ),  
    "exists_is_twin_prime_gt": GroundTruthEntity(
        canonical_name="exists_is_twin_prime_gt",
        entity_type=EntityType.CONCEPT,
        description='exists n > arg s.t. n and n+2 is prime',
        computational_implementation=lambda m:True,
        discovered_names={"exists_(is_twin_prime_gt_indices_[0])",
                          "exists_(lt_is_twin_prime_indices_[0])"}
    ),
    "exists_pythagorean_triple_gt":  GroundTruthEntity(
        canonical_name="exists_pythagorean_triple_gt",
        entity_type=EntityType.CONCEPT,
        description='exists a b c > arg s.t. a b c are pythagorean triples',
        computational_implementation=lambda m:True,
        discovered_names={"exists_(is_pythagorean_triple_gt_indices_[0, 1, 2])"}
    ),  
}