"""
This package contains production rules for generating new mathematical entities.

It is organized into two main categories:
1. Concept production rules (productions.concepts)
   - Rules that generate new concepts from existing ones
   - Examples: map/iterate, compose, negate, exists, match

2. Conjecture production rules (productions.conjectures)
   - Rules that generate new conjectures from existing concepts/conjectures
   - Examples: equivalence, implication, generalize, compose, strengthen/weaken, analogy
"""

from frame.productions.concepts import (
    ComposeRule,
    ExistsRule,
    MapIterateRule,
    MatchRule,
    NegateRule,
    ForallRule,
    ConstantRule,
    SizeRule,
    SpecializeRule,
)

from frame.productions.conjectures import (
    EquivalenceRule,
    ImplicationRule,
    NonexistenceRule,
    ExclusivityRule,
)

__all__ = [
    # Concept rules
    'ComposeRule',
    'ExistsRule',
    'MapIterateRule',
    'MatchRule',
    'NegateRule',
    'ForallRule',
    'ConstantRule',
    'SizeRule',
    'SpecializeRule',
    # Conjecture rules
    'EquivalenceRule',
    'ImplicationRule',
    'NonexistenceRule',
    'ExclusivityRule',
] 