"""Main entry point for the FRAME REPL."""
import os
import dill
from frame.repl.interface.cli import MathREPLShell
from frame.knowledge_base.knowledge_graph import KnowledgeGraph
import argparse

def main(input_file=None):
    initial_graph = None
    
    if input_file:
        try:
            if not os.path.exists(f"data/graphs/{input_file}"):
                print(f"Error: File '{input_file}' not found.")
            else:
                initial_graph = KnowledgeGraph.load(f"data/graphs/{input_file}")
                print(f"Successfully loaded graph from '{input_file}'.")
        except Exception as e:
            print(f"Error loading file '{input_file}': {str(e)}")
            print("Starting with empty graph.")
    
    repl = MathREPLShell(initial_graph=initial_graph)
    try:
        repl.cmdloop()
    except KeyboardInterrupt:
        print("\nGoodbye!")

if __name__ == '__main__':
    
    parser = argparse.ArgumentParser(description='Start the FRAME REPL.')
    parser.add_argument('--load', type=str, help='Dill filename containing an initial_graph to load. \
                        Reads from data/graphs')
    args = parser.parse_args()
    
    main(input_file=args.load)