"""
This module provides logging utilities for the FRAME project.
"""

import logging
import os
import sys
from pathlib import Path
from typing import Optional
from datetime import datetime

# Configure the logger
logger = logging.getLogger('frame')
logger.setLevel(logging.INFO)

# Create console handler with a higher log level
console_handler = logging.StreamHandler()
console_handler.setLevel(logging.INFO)

# Create formatter and add it to the handler
formatter = logging.Formatter('%(name)s - %(levelname)s - %(message)s')
console_handler.setFormatter(formatter)

# Add the handler to the logger
logger.addHandler(console_handler) 