namespace Basics

def Set (α : Type) := α → Prop

def Set.mem {α : Type} (x : α) (s : Set α) := s x

notation:50 x " ∈ " s => Set.mem x s

def Set.empty {α : Type} : Set α := λ _ => False

def Set.univ {α : Type} : Set α := λ _ => True

def Set.union {α : Type} (s₁ s₂ : Set α) : Set α :=
  λ x => (s₁ x) ∨ (s₂ x)

def Set.inter {α : Type} (s₁ s₂ : Set α) : Set α :=
  λ x => (s₁ x) ∧ (s₂ x)

end Basics
