#!/bin/bash
# Script to run an experiment with a standard policy (not interestingness-guided)

echo "Running experiment with interestingness-guided policy with the comprehensibility interestingness function..."

# Go to the project root directory
cd "$(dirname "$0")/.."

# Run the experiment with the standard policy config
python -m frame.theory_builder \
  --config-name succ_zero_standard_experiment \
  experiment.num_episodes=64 \
  experiment.max_steps=1000 \
  experiment.episode_timeout_seconds=120 \
  experiment.num_workers=64 \
  z3_usage.use_z3_prover=true \
  z3_usage.use_z3_example_search=true \
  ++policy.params.interestingness_function_path="frame/interestingness/learning/baselines/hr_comprehensibility.py"

echo "Experiment completed!" 