#!/bin/bash
# Script to run an experiment that generates a new interestingness function with an LLM
# and uses it in a mathematical discovery experiment.

echo "Running experiment with generated interestingness function..."

# Go to the project root directory
cd "$(dirname "$0")/.."

# Fix issue with doubled path in model config file loading
export MODEL_CONFIG_DIR="$(pwd)/frame/configs/models"
export PROMPT_TEMPLATE_DIR="$(pwd)/frame/configs/prompts"
export INTERESTINGNESS_DEBUG=1

echo "Using model config directory: $MODEL_CONFIG_DIR"
echo "Using prompt template directory: $PROMPT_TEMPLATE_DIR"

# Run the experiment with the generated interestingness config
nohup python -m frame.theory_builder \
  --config-name succ_zero_generated_interestingness_experiment \
  experiment.num_episodes=64 \
  experiment.max_steps=1000 \
  experiment.episode_timeout_seconds=120 \
  experiment.num_workers=64 \
  z3_usage.use_z3_prover=true \
  z3_usage.use_z3_example_search=true \
  experiment.num_interestingness_to_generate=64

echo "Experiment completed!" 