#!/bin/bash
# Script to run FunSearch WITH the abstraction mechanism ENABLED, using Hydra defaults.

echo "Running FunSearch experiment with abstraction enabled (using defaults from mid.yaml)..."

# --- Configurable Parameters ---
# Most parameters are now expected to be set in configs/funsearch/mid.yaml
# You can still override specific ones via the command line below if needed.
# OUTPUT_DIR is now managed by Hydra.
# --- End Configurable Parameters ---

# Go to the project root directory
cd "$(dirname "$0")/.."

# Hydra will create the output directory.

echo "Output directory will be managed by Hydra."
echo "Running with defaults from mid.yaml and:"
echo "  Abstraction: ENABLED"

# Run the FunSearch main script using Hydra overrides
# Only enabling abstraction explicitly.
nohup python -m frame.funsearch.main \
  --config-name funsearch-low-budget \
  abstraction.enabled=true

echo "FunSearch experiment with abstraction completed!"
# Output directory location depends on Hydra configuration (e.g., ./outputs/YYYY-MM-DD/HH-MM-SS)
echo "Results saved in Hydra output directory." 