"""
Simple test interestingness function for testing.
Returns a fixed value based on entity type.
"""

from frame.knowledge_base.knowledge_graph import KnowledgeGraph, NodeType

def calculate_interestingness(entity_id: str, graph: KnowledgeGraph) -> float:
    """
    A simple interestingness function for testing.
    Returns 0.75 for concepts and 0.45 for conjectures.
    
    Args:
        entity_id: Entity ID to score
        graph: Knowledge graph containing the entity
        
    Returns:
        Interestingness score between 0 and 1
    """
    # Get the entity and its type
    try:
        entity, node_type, _ = graph.get_node(entity_id)
        
        # Return different values based on entity type
        if node_type == NodeType.CONCEPT:
            return 0.75
        elif node_type == NodeType.CONJECTURE:
            return 0.45
        else:
            return 0.0
            
    except Exception as e:
        print(f"Error scoring entity {entity_id}: {e}")
        return 0.0 