import unittest
import os
from frame.tools.z3_runtime import Z3DslRuntime


class TestZ3DslRuntime(unittest.TestCase):
    def setUp(self):
        self.z3_runtime = Z3DslRuntime()

    def test1(self):
        file_path = os.path.join(
            os.path.dirname(__file__), "test1.smt"
        )
        with open(file_path, "r") as file:
            smtlib_string = file.read()
        proof_found, counter_example = self.z3_runtime.prove(smtlib_string)
        self.assertTrue(proof_found)
        self.assertIsNone(counter_example)
    
    def test2(self):
        file_path = os.path.join(
            os.path.dirname(__file__), "test2.smt"
        )
        with open(file_path, "r") as file:
            smtlib_string = file.read()
        proof_found, counter_example = self.z3_runtime.prove(smtlib_string)
        self.assertFalse(proof_found)
        print(counter_example)


if __name__ == "__main__":
    unittest.main()

