
library(torchvision)
library(torchdatasets)
library(torch)
library(luz)

library(FNN)
library(ScreeNOT)

source('mercat.R')

## jaccard index
jac <- function(a, b) {
  inter_ab <- length(intersect(a, b))
  union_ab <- length(a) + length(b) - inter_ab
  return (inter_ab/union_ab)
}

ngbh_eval <- function(X, Y, k=50)
{
  if (ncol(X) >= 25)
  {
    X_denoised <- adaptiveHardThresholding(X, k=min(50, floor(ncol(X)/2)-1))$Xest
    X_ngbh <- get.knn(X_denoised, k=k, algorithm="kd_tree")$nn.index
  } else {
    
    X_ngbh <- get.knn(X, k=k, algorithm="kd_tree")$nn.index
  }
  Y_ngbh <- get.knn(Y, k=k, algorithm="kd_tree")$nn.index
  mean(sapply(1:nrow(X_ngbh), function(i){jac(X_ngbh[i,], Y_ngbh[i,])}))
}

eucl_dist_rank_eval <- function(X, Y)
{
  X_dist <- as.vector(dist(X, method='euclidean'))
  Y_dist <- as.vector(dist(Y, method='euclidean'))
  
  cor(X_dist, Y_dist, method='spearman')
}
## This is the version that considers Y to be on the sphere
sphere_dist_rank_eval <- function(X, Y)
{
  X_dist <- as.vector(dist(X, method='euclidean'))
  Y_dist <- Y %*% t(Y)
  Y_dist <- acos( Y_dist[lower.tri(Y_dist)] )
  
  cor(X_dist, Y_dist, method='spearman', use="complete.obs")
}

angle_rank_eval <- function(X, Y, geodesic=F)
{
  X_ang <- as_array(compute_angles(torch_tensor(X), 64))
  Y_ang <- as_array(compute_angles(torch_tensor(Y), 64, geodesic=geodesic))
  
  cor(as.vector(X_ang), as.vector(Y_ang), method='spearman')
}
angle_cor_eval <- function(X, Y, geodesic=F)
{
  X_ang <- as_array(compute_angles(torch_tensor(X), 64))
  Y_ang <- as_array(compute_angles(torch_tensor(Y), 64, geodesic=geodesic))
  
  cor(as.vector(X_ang), as.vector(Y_ang), method='pearson')
}

## epsilon ball around points in X and Y, measure density inside (# of points), correlate them. Set epsilon to average distance to k-th neighbor
density_eval <- function(X, Y, k=25)
{
  X_k_dist <- mean(get.knn(X, k=k, algorithm="kd_tree")$nn.dist[,k])
  Y_k_dist <- mean(get.knn(Y, k=k, algorithm="kd_tree")$nn.dist[,k])

  X_density <- rowSums(as.matrix(dist(X, method='euclidean')) < X_k_dist) - 1
  Y_density <- rowSums(as.matrix(dist(Y, method='euclidean')) < Y_k_dist) - 1

  cor(X_density, Y_density, method='pearson')
}