import json
import random

# 输入输出文件路径
input_file = 'formatted_tacos_test.json'         # 原始 JSON 文件名
output_file = 'sampled_tacos_test_50.json'   # 输出的新 JSON 文件名

# 读取原始 JSON 文件
with open(input_file, 'r', encoding='utf-8') as f:
    data = json.load(f)

# 计算 25% 的数量（至少保留 1 条）
# sample_size = max(1, round(0.2 * len(data))) #0.25
sample_size = max(1, 50)
# 随机采样
sampled_data = random.sample(data, sample_size)

# 保存为新 JSON 文件
with open(output_file, 'w', encoding='utf-8') as f:
    json.dump(sampled_data, f, indent=2, ensure_ascii=False)

print(f"已从 {input_file} 中抽取 {sample_size} 条样本，保存至 {output_file}")
