import json

# 读取原始JSON文件
with open('formatted_tacos_test.json', 'r') as file:
    data = json.load(file)

# 修改字段
for item in data:
    # 修改字段名
    item['caption'] = item.pop('normal_caption')
    video_length = item['video_length']
    item['timestamp'] = [t * video_length for t in item.pop('solution')]

# 保存修改后的JSON到新文件
with open('tacos_test_trans.json', 'w') as file:
    json.dump(data, file, indent=2)

print("处理完成，已保存到 output.json")