import json

input_path = "sampled_activitynet_train.json"
output_path = "sampled_activitynet_train_fixed.json"

with open(input_path, "r") as f:
    data = json.load(f)

# 添加 .mp4（避免重复加）
for item in data:
    if "video" in item and not item["video"].endswith(".mp4"):
        item["video"] += ".mp4"

with open(output_path, "w") as f:
    json.dump(data, f, indent=2)

print(f"✅ Fixed JSON saved to: {output_path}")