source ~/miniconda3/etc/profile.d/conda.sh
conda activate teval

# python3 scripts/model_merger.py --local_dir checkpoints/v3/easy_r1/qwen2_5_vl_7b_tvg_1_activity_ca/global_step_12/actor
# pip install qwen-vl-utils
GPUS=8
MODEL_PATH=./checkpoints/qwen2_5 #checkpoints/v3/easy_r1/qwen2_5_vl_7b_tvg_activity_source/global_step_900/actor/huggingface #checkpoints/v3/easy_r1/qwen2_5_vl_7b_tvg_1_activity/global_step_8/actor/huggingface #checkpoints/v2/easy_r1/qwen2_5_vl_3b_tvg/global_step_12/actor/huggingface #checkpoints/easy_r1/qwen2_5_vl_3b_tvg/global_step_300/actor/huggingface
TASKS=temporal_grounding_activitynet
VISUAL_TOKEN=1605632

###### for huggingface setting ######
export HF_HOME="/home/j50048030/.cache/huggingface"
export TRANSFORMERS_CACHE=$HF_HOME/transformers
###### for huggingface setting ######

export DECORD_EOF_RETRY_MAX=20480

accelerate launch --num_processes=$GPUS --main_process_port 12345 -m lmms_eval \
  --model qwen2_5_vl \
  --model_args "pretrained=$MODEL_PATH,total_pixels=$VISUAL_TOKEN" \
  --device cuda \
  --tasks $TASKS \
  --batch_size 1 \
  --log_samples \
  --log_samples_suffix debug \
  --output_path $MODEL_PATH/lmms_eval/logs/gpu_${GPUS}_visual_token_${VISUAL_TOKEN}/tvg  \
  --verbosity=DEBUG