I would like you to act as a quizmaster who designs questions based on a provided image that would challenge adults to think critically. The image in question is a screenshot from the homepage or section of a news website. You are to create high-quality questions focusing on the information displayed within this webpage, which might contain multiple news articles. Your questions should specifically target the picture and the thematic information of a single article. Your question should be answerable, and checkable. If it is challenging to pose questions about a specific article due to insufficient information, design questions around the main information and events depicted in the image. Within your capabilities, try to make the questions more challenging.

A well-crafted question about an event should allow respondents to gain deeper insights by observing and analyzing the event, paying attention to the following aspects:

1. **Concrete Recognition (Comprehension and Remembering)**:
   - These levels involve recalling facts and explaining concepts.
   - Example questions include:
     - "What are the key points in this news story?" (Remembering)
     - "How would you explain the main event reported here?" (Comprehension)
2. **Analytical Questions (Analysis)**:
   - This level involves breaking down information into components to understand relationships and meanings.
   - Example questions:
     - "What are the factors that led to this event?"
     - "How does this event relate to other current issues?" 
3. **Divergent Thinking (Creation)**:
   - This is the highest level where individuals generate new ideas and integrate different concepts.
   - Example questions:
     - "How could you create a new headline that captures the essence of the event differently?"
     - "If you were the reporter, how would you approach this story to provide a unique angle?"
     - "Do you think the report's presentation was fair? Why or why not?"
4. **Real-world Assistance (Application)**:
    - This level involves applying knowledge to real-world situations.
    - Example questions:
      - "Please present this news in Arabic and output it in markdown format."
      - "Organize all the news on this page in the form of an HTML table, which needs to include the title, release time, and keywords."
      - "Sort out the exchange rate data and plot them using Julia language."
      - "Please write a summary of the news in Vietnamese"
      - "Can you give me a example of this update in Python?" (Maybe can specify the update content)
    - For programming language and natural language specification, you can specify any language (such as python, R, Julia, etc. as programming languages, Swedish, Czech, Portuguese, Polish, Serbian, etc. as natural languages).

Maybe it is difficult to come up with questions about some aspects of some pictures, so you can be biased when setting questions.

Consider designing a multi-round Q&A process, progressively deepening the understanding of the event's essence.

Please note that although the image may contain a lot of political content, try to avoid questions with any political bias when asking questions. Your questions should focus on understanding and thinking about the image, not on political opinions.

You should try to be innovative, and you may propose some difficult questions, as well as multiple-choice questions, fill-in-the-blank questions, or even image-text matching questions, and sequencing questions. Within your capabilities, try to make the questions more challenging.

At the same time, you need to generate how this question should be scored, that is, the criteria. Each question is scored as $0\sim 10$, and the correct answers should be scored scored as $10$. Your grading criteria need to be clear and reasonable, closely aligned with the topic. When establishing the criteria, you should also consider measurability and flexibility to accommodate the answers of various respondents.
