import json
import re

def convert_annotations(input_path, output_path):
    with open(input_path, 'r') as f:
        data = json.load(f)

    result = {}
    for key, value in data.items():
        # Remove ```json ... ``` wrapper if present
        content = value.strip().strip("```json").strip("```")

        # Try to extract temporal information
        if '"start_time"' in content and '"end_time"' in content:
            matches = re.findall(r'"start_time":\s*"([\d.]+)".*?"end_time":\s*"([\d.]+)"', content)
            if matches:
                start, end = matches[0]
                result[key] = f"The given query happens in {start} - {end} seconds."
            else:
                result[key] = "The given query happens in 0.0 - 0.0 seconds."  # fallback
        elif '"bbox_2d"' in content:
            result[key] = "The given query happens in 0.0 - 0.0 seconds."
        else:
            result[key] = "The given query happens in 0.0 - 0.0 seconds."  # unknown type

    # Save to output file
    with open(output_path, 'w') as f:
        json.dump(result, f, indent=4)

    print(f"Processed {len(data)} entries. Output saved to {output_path}.")

# Example usage
convert_annotations("/mnt/data/shared_home/j50048030/Temporal-R1/Qwen/Qwen2.5-VL-7B-Instruct/lmms_eval/logs/gpu_8_visual_token_1605632/tvg/submissions/inference_results_temporal_grounding_activitynet_tvg_2025-04-21-00-51-36.json", "/mnt/data/shared_home/j50048030/Temporal-R1/Qwen/Qwen2.5-VL-7B-Instruct/lmms_eval/logs/gpu_8_visual_token_1605632/tvg/submissions/inference_results_temporal_grounding_activitynet_tvg_2025-04-21-00-51-36_v1.json")

