# MatMamba

# Folder organization

The matmamba directory contains the core MatMamba layer implementation, along with the LM and Image model definitions.

The 'scripts/' directory contains all the scripts used to produce the checkpoints that were used to produce the results in the paper.

train_fineweb.py contains code for the MatMamba-LM training runs.
train_imagenet.py contains code for the MatMamba-Vision training runs.

# Installation Instructions

To install the package, run the following command:

```bash
pip install -e .
```

To create a MatMamba2 layer:
```python
from matmamba import MatMamba2

layer = MatMamba2(d_model=1024)
'''
MatMamba2(
    (in_proj): Linear(in_features=1024, out_features=4416, bias=False)
    (drop1): Dropout(p=0.0, inplace=False)
    (conv1d): Conv1d(2304, 2304, kernel_size=(4,), stride=(1,), padding=(3,), groups=2304)
    (act): SiLU()
    (norm): RMSNorm()
    (out_proj): Linear(in_features=2048, out_features=1024, bias=False)
    (drop2): Dropout(p=0.0, inplace=False)
)
'''

Example usage:

x = torch.randn(batch, length, dim)


```
