This code is based on the implementation:

```
@misc{deleu2018mamlrl,
  author = {Tristan Deleu},
  title  = {{Model-Agnostic Meta-Learning for Reinforcement Learning in PyTorch}},
  note   = {Available at: https://github.com/tristandeleu/pytorch-maml-rl},
  year   = {2018}
}
```

#### Requirements
 - Python 3.5 or above
 - PyTorch 1.3
 - Gym 0.15
 - mujuco150
## Usage

#### Training
You can use the [`train.py`](train.py) script in order to train the meta-policy over augmented tasks and non-critical tasks. Note that by default, logs are available in [`train.py`](train.py) but **are not** saved (eg. the returns during meta-training). For example, to run the script on HalfCheetah-Vel:
```
python train.py --config configs/maml/halfcheetah-vel.yaml --output-folder maml-halfcheetah-vel --seed 1 --num-workers 8
```

```
python train.py --config configs/maml/ant-vel.yaml --output-folder maml-ant-vel --seed 1 --num-workers 8
```

#### Testing
Once you have meta-trained the policy, you can test it on the same environment using [`test.py`](test.py):
```
python test.py --config maml-halfcheetah-vel/config.json --policy maml-halfcheetah-vel/policy.th --output maml-halfcheetah-vel/results.npz --meta-batch-size 20 --num-batches 10  --num-workers 8
```

```
python test.py --config maml-ant-vel/config.json --policy maml-ant-vel/policy.th --output maml-ant-vel/results.npz --meta-batch-size 20 --num-batches 10  --num-workers 8
```

