#!/bin/bash

export SZ=32
export BS=24
export N_CLASSES=10
export ARCHITECTURE='basic'
export DELTA_DIM=8

# paths to directories
export TRAIN_DIR=~/Desktop/Projects/Model-Based-ImageNet/datasets/imagenet/tmp/train_first_50
export VAL_DIR=./datasets/imagenet-c/brightness+snow/10-59/1
export LOG_DIR=./ncluster/runs/lambda-hyperplane
export MODEL_PATH=./training/models/svhn-brightness.pt
export SAVE_PATH=./tmp

ulimit -n 4096
python -m torch.distributed.launch \
    --nproc_per_node=4 --nnodes=1 --node_rank=0 training/train_imagenet_nv.py \
    --train-data-dir  $TRAIN_DIR --val-data-dir $VAL_DIR --logdir $LOG_DIR --model-path $MODEL_PATH --save-path $SAVE_PATH \
    --data-size $SZ --batch-size $BS --num-classes $N_CLASSES  --half-prec \
    --architecture ${ARCHITECTURE} --delta-dim $DELTA_DIM  \
    --distributed --init-bn0 --no-bn-wd --setup-verbose  --optimizer adadelta --mrt -k 100 \
    --phases "[{'ep': 0, 'trndir': ''}, {'ep': (0, 100), 'lr': (1.0, 1.0)}]"

    # --phases "[{'ep': 0, 'trndir': ''}, {'ep': (0, 200), 'lr': (0.05, 0.001)}]"