#!/bin/bash

export SZ=64
export BS=64
export N_CLASSES=43
export ARCHITECTURE='basic'
export DELTA_DIM=8
export N_EPOCHS=100

# paths to directories
export TRAIN_DIR=~/Desktop/Projects/Model-Based-ImageNet/datasets/imagenet/tmp/train_first_50
# export VAL_DIR=~/Desktop/Projects/Model-Based-ImageNet/datasets/imagenet_c/full/tmp_fog/first_fifty/5
export VAL_DIR=./datasets/imagenet-c/contrast+snow/10-59/3
# export VAL_DIR_2=~/Desktop/Projects/Model-Based/ImageNet/datasets/tiny_imagenet/tiny-imagenet-200/val
export LOG_DIR=./ncluster/runs/lambda-hyperplane
export MODEL_PATH=./training/models/gtsrb-contrast.pt
export SAVE_PATH=./tmp


ulimit -n 4096

python -m torch.distributed.launch \
    --nproc_per_node=4 --nnodes=1 --node_rank=0 training/train_imagenet_nv.py \
    --train-data-dir  $TRAIN_DIR --val-data-dir $VAL_DIR --logdir $LOG_DIR --model-path $MODEL_PATH --save-path $SAVE_PATH \
    --data-size $SZ --batch-size $BS --num-classes $N_CLASSES  --half-prec \
    --architecture ${ARCHITECTURE} --delta-dim $DELTA_DIM \
    --distributed --init-bn0 --no-bn-wd --setup-verbose  --pgd --optimizer adadelta \
    --phases "[{'ep': 0, 'trndir': ''}, {'ep': (0, 100), 'lr': (1.0, 1.0)}]"

python -m torch.distributed.launch \
    --nproc_per_node=4 --nnodes=1 --node_rank=0 training/train_imagenet_nv.py \
    --train-data-dir  $TRAIN_DIR --val-data-dir $VAL_DIR --logdir $LOG_DIR --model-path $MODEL_PATH --save-path $SAVE_PATH \
    --data-size $SZ --batch-size $BS --num-classes $N_CLASSES  --half-prec \
    --architecture ${ARCHITECTURE} --delta-dim $DELTA_DIM \
    --distributed --init-bn0 --no-bn-wd --setup-verbose --mrt -k 10 --optimizer adadelta \
    --phases "[{'ep': 0, 'trndir': ''}, {'ep': (0, 100), 'lr': (1.0, 1.0)}]"

python -m torch.distributed.launch \
    --nproc_per_node=4 --nnodes=1 --node_rank=0 training/train_imagenet_nv.py \
    --train-data-dir  $TRAIN_DIR --val-data-dir $VAL_DIR --logdir $LOG_DIR --model-path $MODEL_PATH --save-path $SAVE_PATH \
    --data-size $SZ --batch-size $BS --num-classes $N_CLASSES  --half-prec \
    --architecture ${ARCHITECTURE} --delta-dim $DELTA_DIM \
    --distributed --init-bn0 --no-bn-wd --setup-verbose --mat -k 10 --optimizer adadelta \
    --phases "[{'ep': 0, 'trndir': ''}, {'ep': (0, 100), 'lr': (1.0, 1.0)}]"