import sys
from openai import OpenAI


BASE_URL = "https://rlse6222cwnbk2-8000.proxy.runpod.net/v1"
API_KEY = ""
PROMPT = "<|im_start|>system\nYou are a helpful assistant<|im_end|>\n<|im_start|>user\nWrite a response to this post:\nCMV: Women's sports leagues shouldn't exist.<|im_end|>\n<|im_start|>"


def main() -> None:
    client = OpenAI(base_url=BASE_URL, api_key=API_KEY)

    try:
        models = client.models.list()
        if not models.data:
            print("No models available from server.", file=sys.stderr)
            sys.exit(1)
        model_id = models.data[0].id
    except Exception as exc:  # noqa: BLE001
        print(f"Failed to list models: {exc}", file=sys.stderr)
        sys.exit(1)

    try:
        stream = client.completions.create(
            model=model_id,
            prompt=PROMPT,
            max_tokens=1000,
            temperature=0.5,
            stream=True,
            extra_body={
                "skip_special_tokens": False,
                "include_stop_str_in_output": True,
                "include_stop_reason": True,
            },
        )
        finish_reason = None
        for chunk in stream:
            if chunk.choices and chunk.choices[0].text:
                print(chunk.choices[0].text, end="", flush=True)
            if chunk.choices and chunk.choices[0].finish_reason is not None:
                finish_reason = chunk.choices[0].finish_reason
        print()
        if finish_reason is not None:
            print(f"[finish_reason: {finish_reason}]")
    except Exception as exc:  # noqa: BLE001
        print(f"\nGeneration failed: {exc}", file=sys.stderr)
        sys.exit(1)


if __name__ == "__main__":
    main()


