"""
Examples module for safety-examples repository.

This module ensures that the safety-tooling package is properly added to the Python path,
allowing imports from the safety-tooling submodule to work correctly.
"""

import os
import sys

# Add the parent directory of `safety_tooling` to sys.path
safety_tooling_path = os.path.abspath(os.path.join(os.path.dirname(__file__), "../safety-tooling"))
if safety_tooling_path not in sys.path:
    sys.path.insert(0, safety_tooling_path)
