

# FIM

Open-source code for "Center of Gravity-Guided Focusing Influence
Mechanism for Multi-Agent Reinforcement Learning"


## Installation instructions

Install Python packages

```shell
# require Anaconda 3 or Miniconda 3
conda create -n fim python=3.8 -y
conda activate fim

bash install_dependecies.sh
```

Set up StarCraft II (2.4.10) and SMAC:

```shell
bash install_sc2.sh
```

This will download SC2.4.10 into the 3rdparty folder and copy the maps necessary to run over.

Set up Google Football:

```shell
bash install_gfootball.sh
```

Update GRF scenarios (Warning: this will overwrite existing map files in the gfootball package):
```shell
python update_grf_scenario.py
```

## Command Line Tool

**Run experiments**

```shell
# Push-2-Box
python main.py --config=FIM_MPE --env-config=push_box with env_args.map_name=push_box eta=5 alpha=0.1 delta=0.1 kappa=0 

# SMAC
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=5m_vs_6m eta=50 alpha=5 delta=0.05 kappa=0.01 td_lambda=0.3 epsilon_anneal_time=1000000 
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=8m_vs_9m eta=50 alpha=5 delta=0.05 kappa=0.01 epsilon_anneal_time=500000 
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=3s_vs_5z eta=50 alpha=1 delta=0.1 kappa=0.005 
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=corridor eta=50 alpha=5 delta=0.05 kappa=0.01 
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=MMM2 eta=50 alpha=5 delta=0.15 kappa=0.01
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=6h_vs_8z eta=50 alpha=5 delta=0.1 kappa=0.05 td_lambda=0.3 epsilon_anneal_time=1000000 
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=27m_vs_30m eta=50 alpha=5 delta=0.05 kappa=0.01 rnn_hidden_dim=256 epsilon_anneal_time=2000000
python main.py --config=FIM_SMAC --env-config=sc2 with env_args.map_name=3s5z_vs_3s6z eta=50 alpha=5 delta=0.15 kappa=0.01 rnn_hidden_dim=256

# GRF
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_2_vs_2 eta=10 alpha=1 delta=0.5 kappa=0.01
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_3_vs_2 eta=10 alpha=10 delta=0.1 kappa=0.01
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_4_vs_3 eta=10 alpha=10 delta=0.2 kappa=0.01
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_counterattack eta=10 alpha=10 delta=0.1 kappa=0.01
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_2_vs_2_full_field eta=10 alpha=10 delta=0.5 kappa=0.01 batch_size=128
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_3_vs_2_full_field eta=10 alpha=1 delta=0.1 kappa=0.01
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_4_vs_3_full_field eta=10 alpha=10 delta=0.2 kappa=0.01 batch_size=128
python main.py --config=FIM_GRF --env-config=grf with env_args.map_name=academy_counterattack_full_field eta=10 alpha=1 delta=0.5 kappa=0.001

# SMACv2
pythohn main.py --config=FIM_SMAC --env-config=sc2v2 with env_args.map_name=protoss_5_vs_5 eta=50 alpha=5 delta=0.25 kappa=0.01
pythohn main.py --config=FIM_SMAC --env-config=sc2v2 with env_args.map_name=terran_5_vs_5 eta=50 alpha=5 delta=0.25 kappa=0.01
pythohn main.py --config=FIM_SMAC --env-config=sc2v2 with env_args.map_name=zerg_5_vs_5 eta=50 alpha=5 delta=0.25 kappa=0.01

# MPE
main.py --config=FIM_MPE --env-config=gymma with env_args.time_limit=25 env_args.key=pz-mpe-simple-spread-v3 eta=50 alpha=5 delta=0.2 kappa=0.01
```

The config files act as defaults for an algorithm or environment.

They are all located in `src/config`.
`--config` refers to the config files in `src/config/algs`
`--env-config` refers to the config files in `src/config/envs`


To enable experiment tracking with WandB, append the following parameters:

```shell
wandb=True key={YOUR_API_KEY} project={YOUR_PROJECT} entity={YOUR_ENTITY}
```

All results will be stored in the `Results` folder and named with `map_name`, and we store the test wining rate with csv format in `csv_files`.

**Kill all training processes**

```shell
# all python and game processes of current user will quit.
bash clean.sh
```
