# Llama instruction model base prompt
BASE_INSTRUCTION = "You are a helpful assistant."

# x -> q(x)
Q_X_INSTRUCTION = "You are an automated assistant tasked with rephrasing specific questions into open-ended queries to encourage detailed exploration and discussion of the key topics mentioned."

Q_X_PROMPT = (
    "Your goal is to prompt someone to write a paragraph exploring the topic without directly revealing the answer.\n\n"
    +"You will be given an original question, labeled as 'Question 1.' Your task is to rephrase this into a new question, labeled as 'Question 2.' "
    +"This new question should encourage someone to provide a comprehensive exploration of the key topic from the original question.\n\n"
    +"Examples for Guidance:\n\n"
    +"Example 1:\n"
    +"Question 1: Which sea creature is the world's largest invertebrate?\n"
    +"Question 2: Write a paragraph about the world's largest invertebrate.\n\n"
    +"Example 2:\n"
    +"Question 1: Princess Estelle, Duchess of Östergötland, granddaughter to King Carl XVI Gustaf, became 2nd in line to what nation's throne when born in 2012?\n"
    +"Question 2: Write a paragraph about the nation's throne that Princess Estelle, Duchess of Östergötland, became 2nd in line to when born in 2012.\n\n"
    +"Example 3:\n"
    +"Question 1: In which century was the printing press established in Britain?\n"
    +"Question 2: Write a paragraph about the century in which the printing press was established in Britain.\n\n"
    +"Example 4:\n"
    +"Question 1: What type of creature is Chewbacca?\n"
    +"Question 2: Write a paragraph about the type of creature that Chewbacca is.\n\n"
    +"Now, please rephrase the following question:\n"
    +"Question 1: <question>\n"
    +"Question 2: "
)


# x -> y_pred 
X_PRED_Y_PROMPT = (
    "Question: <question>\n"
    +"Answer: "
)
X_PRED_Y_PROMPT_MED = (
    "Question: <question> <option>"
    +"\nAnswer: "
)


# q, d -> z
Z_PROMPT = (
    "Directly state the answer without phrases like 'the correct answer is.'\n\n"
    + "Given the retrieved context, answer the question as accurately as possible.\n"
    + "Question: <question>\n"
    + "Retrieved Context: <title> - <context>\n"
    + "Answer: "
)

Z_PROMPT_MED = (
    "Directly state the answer without phrases like 'the correct answer is.'\n\n"
    + "Given the retrieved context, answer the question as accurately as possible.\n"
    + "Retrieved Context: <title> - <context>\n"
    + "Question: <question>\n"
    + "Answer: "
)

# x, z_pred -> y_pred (train)
XZ_PRED_Y_PROMPT = (
    "The task is to answer questions based on a context generated by a language model in response to a question about relevant information. Follow the behavior instructions below:\n"
    + "If you cannot provide an answer or if you do not trust the information, respond with ‘no answer’.\n"
    + "Context: <context>\n" 
    + "Question: <question>\n"
    + "Answer: "
)      


XZ_PRED_Y_PROMPT_MED = (
    "The task is to answer questions based on a context generated by a language model in response to a question about relevant information. Follow the behavior instructions below:\n"
    + "Directly state the answer without phrases like 'the correct answer is.'\n"
    + "If you cannot provide an answer or if you do not trust the information, respond with ‘no answer’.\n"
    + "Context: <context>\n"
    + "Question: <question> <option>\n"
    + "Answer: "
)


# x, z_pred, c -> y_pred (eval)
XZ_PRED_Y_PROMPT_EVAL = (
    "The task is to answer questions based on a context generated by a language model in response to a question about relevant information, along with the model's confidence level in the provided answer.\n" 
    + "Context: <context>\n"
    + "Question: <question>\n"
    + "Model Confidence: <confidence>\n"
    + "Answer: "
)


XZ_PRED_Y_PROMPT_EVAL_MED = (
    "The task is to answer questions based on a context generated by a language model in response to a question about relevant information, along with the model's confidence level in the provided answer.\n" 
    + "Context: <context>\n"
    + "Question: <question> <option>\n"
    + "Model Confidence: <confidence>\n"
    + "Answer: "  
)



# (y, y_pred) -> c
EVALUATION_INSTRUCTION = (
    "You are an automated grading assistant helping a teacher grade student answers.\n\n"
)

EVALUATION_PROMPT = (
    "The problem is: <question>\n\nThe correct answer for this problem is: <ground-truth>\n"
    + "A student submitted the answer: <prediction>\n\n"
    + "The student's answer must be correct and specific but not overcomplete "
    + "(for example, if they provide two different answers, they did not get the question right). "
    + "However, small differences in formatting should not be penalized (for example, 'New York City' is equivalent to 'NYC').\n"
    + "Did the student provide an equivalent answer to the ground truth? Please answer yes or no without any explanation: "
)

EVALUATION_PROMPT_10 = (
    "The problem is: <question>\n\nThe correct answer for this problem is: <ground-truth>\n"
    + "The following are answers submitted by several students:\n"
    + "Student 1: <prediction1>\n"
    + "Student 2: <prediction2>\n"
    + "Student 3: <prediction3>\n"
    + "Student 4: <prediction4>\n"
    + "Student 5: <prediction5>\n"
    + "Student 6: <prediction6>\n"
    + "Student 7: <prediction7>\n"
    + "Student 8: <prediction8>\n"
    + "Student 9: <prediction9>\n"
    + "Student 10: <prediction10>\n"
    + "The student's answer must be correct and specific but not overcomplete "
    + "(for example, if they provide two different answers, they did not get the question right). "
    + "However, small differences in formatting should not be penalized (for example, 'New York City' is equivalent to 'NYC'). "
    + "For each student's answer, did the student provide an equivalent answer to the ground truth? Please answer yes or no for each answer without any explanation: " 
)

EVALUATION_PROMPT_20 = (
    "The problem is: <question>\n\nThe correct answer for this problem is: <ground-truth>\n"
    + "The following are answers submitted by several students:\n"
    + "Student 1: <prediction1>\n"
    + "Student 2: <prediction2>\n"
    + "Student 3: <prediction3>\n"
    + "Student 4: <prediction4>\n"
    + "Student 5: <prediction5>\n"
    + "Student 6: <prediction6>\n"
    + "Student 7: <prediction7>\n"
    + "Student 8: <prediction8>\n"
    + "Student 9: <prediction9>\n"
    + "Student 10: <prediction10>\n"
    + "Student 11: <prediction11>\n"
    + "Student 12: <prediction12>\n"
    + "Student 13: <prediction13>\n"
    + "Student 14: <prediction14>\n"
    + "Student 15: <prediction15>\n"
    + "Student 16: <prediction16>\n"
    + "Student 17: <prediction17>\n"
    + "Student 18: <prediction18>\n"
    + "Student 19: <prediction19>\n"
    + "Student 20: <prediction20>\n\n"
    + "The student's answer must be correct and specific but not overcomplete "
    + "(for example, if they provide two different answers, they did not get the question right). "
    + "However, small differences in formatting should not be penalized (for example, 'New York City' is equivalent to 'NYC'). "
    + "For each student's answer, did the student provide an equivalent answer to the ground truth? Please answer yes or no for each answer without any explanation: " 
)


# uc prompt
CT_PROMPT = (
    "\n\nIs the proposed answer correct?\nChoices:\n(i): no\n(ii): yes"
    +"\nAnswer: "
)

LING_PROMPT = (
    "\n\nProvide the certainty level of answer using the given 11 certainty levels. Give ONLY your certainty level, no other words or explanation."
    +"\nCertainty Levels: Unlikely, Doubtful, Uncertain, Ambiguous, Probable, Likely, Possible, Specified, Confirmed, Certain, Inevitable."
    +"\nFor example: Certainty: <ONLY the certainty level that Answer is correct, without any extra commentary whatsoever; just the certainty level!>"
    +"\nCertainty: "
)

NUMBER_PROMPT = (
    "\n\nProvide the certainty level of answer using the given 11 certainty levels. Give ONLY your certainty level, no other words or explanation."
    +"\nCertainty Levels: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10."
    +"\nFor example: Certainty: <ONLY the certainty level that Answer is correct, without any extra commentary whatsoever; just the number!>"
    +"\nCertainty: "
)


# query regeneration prompt
QUERY_REGENERATION_PROMPT = (
    "Rewrite the original search query below by emphasizing key terms and making it more specific.\n"
    "Example: Write a paragraph about the hormone deficiency implicated in Costello syndrome.\n"
    "Original Query: <query>\n"
    "Please generate a new, refined query without any further explanation:"
)

RERANKING_INSTRUCTION = (
"Given a query and 20 labeled passages, rank them based on their relevance to the query. Consider how well each passage matches the query’s context, key terms, and overall informativeness."    
)

RERANKING_PROMPT = (
    "The following are passages related to the query <query>:\n"
    "[1] <p1>\n"
    "[2] <p2>\n"
    "[3] <p3>\n"
    "[4] <p4>\n"
    "[5] <p5>\n"
    "[6] <p6>\n"
    "[7] <p7>\n"
    "[8] <p8>\n"
    "[9] <p9>\n"
    "[10] <p10>\n"
    "[11] <p11>\n"
    "[12] <p12>\n"
    "[13] <p13>\n"
    "[14] <p14>\n"
    "[15] <p15>\n"
    "[16] <p16>\n"
    "[17] <p17>\n"
    "[18] <p18>\n"
    "[19] <p19>\n"
    "[20] <p20>\n"
    "Rank these passages based on their relevance to the query, using only the format '[#]>[#]>...>[#]'."
)


c_prompts = {
    'ct': CT_PROMPT,
    'ling': LING_PROMPT, 
    'number': NUMBER_PROMPT
}


number_to_uc = ["Unlikely", "Doubtful", "Uncertain", 
                "Ambiguous", "Probable", "Likely", "Possible", 
                "Specified","Confirmed", "Certain", "Inevitable"]


uc_to_number = {"Unlikely": 0, "Doubtful": 1, "Uncertain": 2, 
            "Ambiguous": 3, "Probable": 4, "Likely": 5, "Possible":6, 
            "Specified":7,"Confirmed":8, "Certain":9, "Inevitable":10}