
## Requirements

- A `requirements.txt` file is available at the root of this repository, specifying the required packages for all of our experiments; 
- Python 3.7 is required as we make use of `importlib.resources`

## Reproducing our results

- To generate the Extended Projected Data Jacobian Matrices from a search space see `gen_epdjms.py`. 
- To generate (high dimensional) contrastive embeddings see `make_embs.py`
- To generate the final low dimensional embedding see `reduce_dims.py` 
- To generate the transfer learning plots see `make_contrastive_transfer_plots.py`
- To simulate NAS on a search space see `make_simulations_201.py` and `make_simulations_101.py`
- To generate the t-SNE visualization of different stages of our method see `make_tsne_figs.py` 

# Note:
The code for generating architectures / evaluating architectures in the full 101 search space does not fit within the space of the 
supplimental material and is as such not available.

